
IF OBJECT_ID('P_CONCILIADOR_LINX_CARTAO')IS NOT NULL
BEGIN 
	DROP PROCEDURE P_CONCILIADOR_LINX_CARTAO
END
GO 
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Realizar conciliação de cartão de credito 
'Tabelas.............: 
'Dt Modificação......: 20/01/2021
'Modificação.........: 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
CREATE PROCEDURE P_CONCILIADOR_LINX_CARTAO 

AS 
 --SET NOCOUNT ON 
DECLARE @CD_EMP		INT 
DECLARE @CD_FILIAL	INT 
DECLARE @CD_VD		INT 
DECLARE @CD_CTR		BIGINT 
DECLARE @TIPO		VARCHAR(20)


	CREATE TABLE #PENDENTE_CONCILIACAO (CD_EMP INT, CD_FILIAL INT , CD_VD INT, CD_CTR BIGINT , TIPO VARCHAR(20) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS );


-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

	PRINT 'Capturando periodo pendente.: '+ CONVERT(VARCHAR, GETDATE(), 120);
	
	INSERT INTO #PENDENTE_CONCILIACAO
	SELECT PDV_VD_TEF_PEND.CD_EMP,
		   PDV_VD_TEF_PEND.CD_FILIAL,
		   PDV_VD_TEF_PEND.CD_VD,
		   PDV_VD_TEF_PEND.CD_CTR,
		   'CUPOM_FISCAL'  TIPO
		   
      FROM PDV_VD_TEF_PEND
	 WHERE CD_EMP = 1 
		  
    UNION ALL 

	SELECT PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO ,
		   PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR,
		   'NAO_FISCAL'  TIPO
		   
      FROM PDV_CUPOM_NAO_FISCAL_TEF_PEND 
	 WHERE CD_EMP = 1 
		 
    




IF NOT EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO )			 
BEGIN 
	PRINT 'Não existe perioro pendente.:' ;
	RETURN ;
END 
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

	DECLARE CONCILIADORLINX CURSOR  
	FOR 
		SELECT CD_EMP, 
			   CD_FILIAL, 
			   CD_VD, 
			   CD_CTR, 
			   TIPO
		  FROM #PENDENTE_CONCILIACAO  PEND
		 

	OPEN CONCILIADORLINX;
	FETCH NEXT FROM CONCILIADORLINX INTO @CD_EMP, @CD_FILIAL, @CD_VD, @CD_CTR, @TIPO;
	WHILE @@FETCH_STATUS = 0
	BEGIN
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	
	
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	IF EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO WHERE CD_EMP  = 1 AND CD_FILIAL = @CD_FILIAL AND CD_VD =  @CD_VD  AND CD_CTR = @CD_CTR AND @TIPO = 'CUPOM_FISCAL' )
	BEGIN 
		PRINT 'PROCESSANDO CUPOM FISCAL. 
			   CD_FILIAL.: ' + CONVERT(VARCHAR, @CD_FILIAL) + 
			   ' CD_VD.: '   + CONVERT(VARCHAR, @CD_VD)  + 
			   ' CD_CTR.: '   + CONVERT(VARCHAR, @CD_CTR);
 
		 	INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
														)
			SELECT 
					 PDV_VD.CD_EMP					AS CD_EMP				
					,PDV_VD.CD_FILIAL				AS CD_FILIAL			
					,PDV_VD.CD_CX					AS CD_CX				
					,PDV_VD.NR_ECF					AS NR_ECF				
					,PDV_VD.DT_VD					AS DT_VD				
					,PDV_VD_TEF.VL_CARTAO			AS VLR_VENDA			
					,CONCILIADOR.ST_LOJA			AS COD_SIT				
					,PDV_VD_TEF.CD_ADM_CARTAO		AS IDT_REDE			
					,PDV_VD_TEF.NM_OPERADORA_PDV    AS DESCR_REDE			
					,BANDEIRA.CD_BANDEIRA			AS IDT_PRODUTO			
					,BANDEIRA.TX_DESCRICAO			AS DESCR_PRODUTO		
					,0								AS DESCR_TRN			
					,BANDEIRA.CD_BANDEIRA			AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIÇÃO DE BANDEIRA')		AS DESCR_BANDEIRA		
					,PDV_VD_TEF.QTDE_PARCELAS		AS NUM_PARCELAS		
					,''								AS CODIGO_RESP			
					,0								AS ESTADO_TRN			
					,''								AS DATA_LANC			
					,''								AS DATAFISCAL			
					,CONCILIADOR.CD_AUTORIZACAO		AS COD_AUTORIZ			
					,PDV_VD.ST_VD					AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_VD_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1								AS TP_OP_AUTOMATICO	
					,PDV_VD_TEF.CD_CTR
					,PDV_VD_TEF.CD_VD
					,CONCILIADOR.IDT_TRANSACAO
					,CONCILIADOR.CD_CTR
			  FROM PDV_VD 
				    JOIN PDV_VD_TEF ON PDV_VD.CD_EMP    = PDV_VD_TEF.CD_EMP   
								   AND PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL
								   AND PDV_VD.CD_VD	    = PDV_VD_TEF.CD_VD
					JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR CONCILIADOR ON PDV_VD_TEF.CD_FILIAL = CONCILIADOR.CD_FILIAL
																		 AND ( CONVERT(bigint,PDV_VD_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) OR 
																			    PDV_VD_TEF.NR_AUTORIZACAO  = CONCILIADOR.CD_AUTORIZACAO   ) 
																		 AND PDV_VD_TEF.QTDE_PARCELAS 	   = CONCILIADOR.NR_PARCELAS_LOJA 
																	     AND PDV_VD_TEF.VL_CARTAO		   = CONCILIADOR.VLR_BRUTO_LOJA
				    LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON CONCILIADOR.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
					LEFT JOIN CONCILIACAO_CARTOES_FINAL  FINAL ON PDV_VD.CD_EMP		= FINAL.CD_EMP		
															  AND PDV_VD.CD_FILIAL	= FINAL.CD_FILIAL	
															  AND PDV_VD.CD_CX		= FINAL.CD_CX		
															  AND PDV_VD.NR_ECF		= FINAL.NR_ECF		
	
			  WHERE PDV_VD_TEF.CD_EMP	 = @CD_EMP 
			    AND PDV_VD_TEF.CD_FILIAL = @CD_FILIAL
			 	AND PDV_VD_TEF.CD_VD     = @CD_VD
				AND PDV_VD_TEF.CD_CTR    = @CD_CTR
				AND FINAL.CD_EMP IS NULL 
				AND CONCILIADOR.TPT_REGISTRO = 3 
				AND NOT CONCILIADOR.ST_LOJA IN (90,91)


			PRINT 'Atualizando IDT_TRANSACAO :'
			UPDATE PDV_VD_TEF
			   SET IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO
			  FROM PDV_VD_TEF
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_VD_TEF.CD_CTR = CONCILIACAO_CARTOES_FINAL.CD_CTR_PDV_VD_TEF 
												 AND PDV_VD_TEF.CD_VD  = CONCILIACAO_CARTOES_FINAL.CD_VD 
			 WHERE PDV_VD_TEF.CD_EMP	= @CD_EMP 
			   AND PDV_VD_TEF.CD_FILIAL	= @CD_FILIAL
			   AND PDV_VD_TEF.CD_VD		= @CD_VD
			   AND PDV_VD_TEF.CD_CTR	= @CD_CTR
			
			
			PRINT 'Removendo da pendencia.:'
			DELETE FROM PDV_VD_TEF_PEND
			   FROM PDV_VD_TEF  
			        JOIN PDV_VD_TEF_PEND ON PDV_VD_TEF_PEND.CD_EMP	    = PDV_VD_TEF.CD_EMP	 
								        AND PDV_VD_TEF_PEND.CD_FILIAL	= PDV_VD_TEF.CD_FILIAL  
								        AND PDV_VD_TEF_PEND.CD_VD		= PDV_VD_TEF.CD_VD	 
								        AND PDV_VD_TEF_PEND.CD_CTR	    = PDV_VD_TEF.CD_CTR	 
			
					JOIN CONCILIACAO_CARTOES_FINAL ON PDV_VD_TEF.CD_CTR = CONCILIACAO_CARTOES_FINAL.CD_CTR_PDV_VD_TEF 
												  AND PDV_VD_TEF.CD_VD  = CONCILIACAO_CARTOES_FINAL.CD_VD 
			  WHERE PDV_VD_TEF_PEND.CD_EMP	    = @CD_EMP 
				AND PDV_VD_TEF_PEND.CD_FILIAL	= @CD_FILIAL
				AND PDV_VD_TEF_PEND.CD_VD		= @CD_VD
				AND PDV_VD_TEF_PEND.CD_CTR	    = @CD_CTR	
				 


			
	END
	
-- ==============================================================================================================================================================================	
	IF EXISTS (SELECT TOP 1 * FROM #PENDENTE_CONCILIACAO WHERE CD_EMP  = 1 AND CD_FILIAL = @CD_FILIAL AND CD_VD =  @CD_VD  AND CD_CTR = @CD_CTR AND @TIPO = 'NAO_FISCAL' )
	BEGIN 
		PRINT 'PROCESSANDO NAO FISCAL. 
			   CD_FILIAL.: ' + CONVERT(VARCHAR, @CD_FILIAL) + 
			   ' NR_COO.: '   + CONVERT(VARCHAR, @CD_VD)  + 
			   ' CD_CTR.: '   + CONVERT(VARCHAR, @CD_CTR);		
			INSERT INTO CONCILIACAO_CARTOES_FINAL ( CD_EMP  
												   ,CD_FILIAL 
												   ,CD_CX 
												   ,NR_ECF  
												   ,DT_VD  
												   ,VLR_VENDA 
								 				   ,COD_SIT  
												   ,IDT_REDE  
												   ,DESCR_REDE 
												   ,IDT_PRODUTO 
												   ,DESCR_PRODUTO 
												   ,DESCR_TRN 
												   ,IDT_BANDEIRA		
												   ,DESCR_BANDEIRA		
												   ,NUM_PARCELAS		
												   ,CODIGO_RESP			
												   ,ESTADO_TRN			
												   ,DATA_LANC			
												   ,DATAFISCAL			
												   ,COD_AUTORIZ			
												   ,ST_VENDA			
											 	   ,NSU_SITEF			
												   ,TP_OP_AUTOMATICO
												   ,CD_CTR_PDV_VD_TEF 
												   ,CD_VD
												   ,IDT_TRANSACAO
												   ,CD_CTR_CONCILIADOR
														)	
		    SELECT 
					 PDV_CUPOM_NAO_FISCAL.CD_EMP				AS CD_EMP				
					,PDV_CUPOM_NAO_FISCAL.CD_FILIAL				AS CD_FILIAL			
					,PDV_CUPOM_NAO_FISCAL.CD_CX					AS CD_CX				
					,PDV_CUPOM_NAO_FISCAL.NR_COO				AS NR_ECF				
					,PDV_CUPOM_NAO_FISCAL.DT_CUPOM				AS DT_VD				
					,PDV_RECBTO_TEF.VL_CARTAO					AS VLR_VENDA			
					,CONCILIADOR.ST_LOJA					    AS COD_SIT				
					,PDV_RECBTO_TEF.CD_ADM_CARTAO			    AS IDT_REDE			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_REDE			
					,PDV_RECBTO_TEF.COD_BANDEIRA			    AS IDT_PRODUTO			
					,PDV_RECBTO_TEF.NM_OPERADORA_PDV			AS DESCR_PRODUTO		
					,0										    AS DESCR_TRN			
					,PDV_RECBTO_TEF.COD_BANDEIRA				AS IDT_BANDEIRA		
					,ISNULL(BANDEIRA.TX_DESCRICAO,'SEM DEFINIÇÃO DE BANDEIRA')		AS DESCR_BANDEIRA	
					,PDV_RECBTO_TEF.QTDE_PARCELAS				AS NUM_PARCELAS		
					,''											AS CODIGO_RESP			
					,0											AS ESTADO_TRN			
					,''											AS DATA_LANC			
					,''											AS DATAFISCAL			
					,CONCILIADOR.CD_AUTORIZACAO					AS COD_AUTORIZ			
					,PDV_CUPOM_NAO_FISCAL.ST_CUPOM				AS ST_VENDA			
				 	,CONVERT(VARCHAR(MAX),CONVERT(BIGINT,PDV_RECBTO_TEF.NSU_SITEF))			AS NSU_SITEF			
					,1											AS TP_OP_AUTOMATICO	
					,PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					,PDV_CUPOM_NAO_FISCAL.NR_COO 
					,CONCILIADOR.IDT_TRANSACAO
					,CONCILIADOR.CD_CTR					
			  FROM PDV_CUPOM_NAO_FISCAL 
				    JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
												 AND PDV_CUPOM_NAO_FISCAL.CD_CTR	= PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR
					JOIN PDV_RECBTO_TEF	 ON PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP			= PDV_RECBTO_TEF.CD_EMP
										AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL		= PDV_RECBTO_TEF.CD_FILIAL
										AND PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF	= PDV_RECBTO_TEF.CD_RECTO_TEF

					JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR CONCILIADOR ON PDV_RECBTO_TEF.CD_FILIAL					 = CONCILIADOR.CD_FILIAL
																		 AND ( CONVERT(bigint,PDV_RECBTO_TEF.NSU_SITEF)  = CONVERT(bigint,CONCILIADOR.NSU_LOJA) 
																		    OR PDV_RECBTO_TEF.NR_AUTORIZACAO			 = CONCILIADOR.CD_AUTORIZACAO   ) 
																		 AND PDV_RECBTO_TEF.QTDE_PARCELAS 				 = CONCILIADOR.NR_PARCELAS_LOJA 
																	     AND PDV_RECBTO_TEF.VL_CARTAO					 = CONCILIADOR.VLR_BRUTO_LOJA
				    LEFT JOIN RC_CONCILIADOR_BANDEIRA BANDEIRA ON CONCILIADOR.CD_BANDEIRA_LOJA = BANDEIRA.CD_BANDEIRA 
					LEFT JOIN CONCILIACAO_CARTOES_FINAL  FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP		= FINAL.CD_EMP		
															  AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= FINAL.CD_FILIAL	
															  AND PDV_CUPOM_NAO_FISCAL.CD_CX		= FINAL.CD_CX		
															  AND PDV_CUPOM_NAO_FISCAL.NR_COO		= FINAL.NR_ECF		
	
			  WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP    = @CD_EMP 
			    AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = @CD_FILIAL
			  	AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR    = @CD_CTR
				AND PDV_CUPOM_NAO_FISCAL.NR_COO        = @CD_VD
				AND FINAL.CD_EMP IS NULL 
				AND CONCILIADOR.TPT_REGISTRO = 3 
				AND NOT CONCILIADOR.ST_LOJA IN (90,91)


			PRINT 'Atualizando IDT_TRANSACAO :'
			UPDATE PDV_CUPOM_NAO_FISCAL
			   SET IDT_TRANSACAO = CONCILIACAO_CARTOES_FINAL.IDT_TRANSACAO
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF ON PDV_CUPOM_NAO_FISCAL.CD_EMP    = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP   
												AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL
												AND PDV_CUPOM_NAO_FISCAL.CD_CTR	   = PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP		= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL	= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR		= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL.NR_COO			= @CD_VD

			
			
			PRINT 'Removendo da pendencia.:'
			DELETE FROM PDV_CUPOM_NAO_FISCAL_TEF_PEND
			  FROM PDV_CUPOM_NAO_FISCAL
			       JOIN PDV_CUPOM_NAO_FISCAL_TEF_PEND ON PDV_CUPOM_NAO_FISCAL.NR_COO    = PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO   
												     AND PDV_CUPOM_NAO_FISCAL.CD_CTR	= PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR 
			       JOIN CONCILIACAO_CARTOES_FINAL ON PDV_CUPOM_NAO_FISCAL.CD_EMP	= CONCILIACAO_CARTOES_FINAL.CD_EMP		 
												 AND PDV_CUPOM_NAO_FISCAL.CD_FILIAL	= CONCILIACAO_CARTOES_FINAL.CD_FILIAL	
												 AND PDV_CUPOM_NAO_FISCAL.CD_CX		= CONCILIACAO_CARTOES_FINAL.CD_CX		
												 AND PDV_CUPOM_NAO_FISCAL.NR_COO	= CONCILIACAO_CARTOES_FINAL.NR_ECF	
			 WHERE PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_EMP		= @CD_EMP 
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_FILIAL	= @CD_FILIAL
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.CD_CTR		= @CD_CTR
			   AND PDV_CUPOM_NAO_FISCAL_TEF_PEND.NR_COO		= @CD_VD

				
 	END 			
		 


 	 FETCH NEXT FROM CONCILIADORLINX INTO @CD_EMP, @CD_FILIAL, @CD_VD, @CD_CTR, @TIPO;
	 END;
	 CLOSE CONCILIADORLINX;
	 DEALLOCATE CONCILIADORLINX;
	  
  

	PRINT 'FIM P_CONCILIADOR_LINX_CARTAO!'

	